// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// The BigQuery Storage API expects protocol buffer data to be encoded in the
// proto2 wire format. This allows it to disambiguate missing optional fields
// from default values without the need for wrapper types.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.17.3
// source: sample_data.proto

package exampleproto

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The SampleStruct demonstrates nesting of one proto message inside another.
// This also necessitates the use of proto normalization when communicating the
// descriptor to the BigQuery storage write API.
type SampleStruct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubIntCol *int64 `protobuf:"varint,1,opt,name=sub_int_col,json=subIntCol" json:"sub_int_col,omitempty"`
}

func (x *SampleStruct) Reset() {
	*x = SampleStruct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sample_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampleStruct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleStruct) ProtoMessage() {}

func (x *SampleStruct) ProtoReflect() protoreflect.Message {
	mi := &file_sample_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleStruct.ProtoReflect.Descriptor instead.
func (*SampleStruct) Descriptor() ([]byte, []int) {
	return file_sample_data_proto_rawDescGZIP(), []int{0}
}

func (x *SampleStruct) GetSubIntCol() int64 {
	if x != nil && x.SubIntCol != nil {
		return *x.SubIntCol
	}
	return 0
}

// Define a message type representing the rows in your table.
type SampleData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The following types map directly between protocol buffers and their
	// corresponding BigQuery data types.
	BoolCol    *bool    `protobuf:"varint,1,opt,name=bool_col,json=boolCol" json:"bool_col,omitempty"`
	BytesCol   []byte   `protobuf:"bytes,2,opt,name=bytes_col,json=bytesCol" json:"bytes_col,omitempty"`
	Float64Col *float64 `protobuf:"fixed64,3,opt,name=float64_col,json=float64Col" json:"float64_col,omitempty"`
	Int64Col   *int64   `protobuf:"varint,4,opt,name=int64_col,json=int64Col" json:"int64_col,omitempty"`
	StringCol  *string  `protobuf:"bytes,5,opt,name=string_col,json=stringCol" json:"string_col,omitempty"`
	// The following data types require some encoding to use. See the
	// documentation for the expected data formats:
	// https://cloud.google.com/bigquery/docs/write-api#data_type_conversions
	DateCol       *int32  `protobuf:"varint,6,opt,name=date_col,json=dateCol" json:"date_col,omitempty"`
	DatetimeCol   *string `protobuf:"bytes,7,opt,name=datetime_col,json=datetimeCol" json:"datetime_col,omitempty"`
	GeographyCol  *string `protobuf:"bytes,8,opt,name=geography_col,json=geographyCol" json:"geography_col,omitempty"`
	NumericCol    *string `protobuf:"bytes,9,opt,name=numeric_col,json=numericCol" json:"numeric_col,omitempty"`
	BignumericCol *string `protobuf:"bytes,10,opt,name=bignumeric_col,json=bignumericCol" json:"bignumeric_col,omitempty"`
	TimeCol       *string `protobuf:"bytes,11,opt,name=time_col,json=timeCol" json:"time_col,omitempty"`
	TimestampCol  *int64  `protobuf:"varint,12,opt,name=timestamp_col,json=timestampCol" json:"timestamp_col,omitempty"`
	// Use a repeated field to represent a BigQuery ARRAY value.
	Int64List []int64 `protobuf:"varint,13,rep,name=int64_list,json=int64List" json:"int64_list,omitempty"`
	// Use a nested message to encode STRUCT and ARRAY<STRUCT> values.
	StructCol  *SampleStruct   `protobuf:"bytes,14,opt,name=struct_col,json=structCol" json:"struct_col,omitempty"`
	StructList []*SampleStruct `protobuf:"bytes,15,rep,name=struct_list,json=structList" json:"struct_list,omitempty"`
	// Use the required keyword for client-side validation of required fields.
	RowNum *int64 `protobuf:"varint,16,req,name=row_num,json=rowNum" json:"row_num,omitempty"`
}

func (x *SampleData) Reset() {
	*x = SampleData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sample_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampleData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleData) ProtoMessage() {}

func (x *SampleData) ProtoReflect() protoreflect.Message {
	mi := &file_sample_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleData.ProtoReflect.Descriptor instead.
func (*SampleData) Descriptor() ([]byte, []int) {
	return file_sample_data_proto_rawDescGZIP(), []int{1}
}

func (x *SampleData) GetBoolCol() bool {
	if x != nil && x.BoolCol != nil {
		return *x.BoolCol
	}
	return false
}

func (x *SampleData) GetBytesCol() []byte {
	if x != nil {
		return x.BytesCol
	}
	return nil
}

func (x *SampleData) GetFloat64Col() float64 {
	if x != nil && x.Float64Col != nil {
		return *x.Float64Col
	}
	return 0
}

func (x *SampleData) GetInt64Col() int64 {
	if x != nil && x.Int64Col != nil {
		return *x.Int64Col
	}
	return 0
}

func (x *SampleData) GetStringCol() string {
	if x != nil && x.StringCol != nil {
		return *x.StringCol
	}
	return ""
}

func (x *SampleData) GetDateCol() int32 {
	if x != nil && x.DateCol != nil {
		return *x.DateCol
	}
	return 0
}

func (x *SampleData) GetDatetimeCol() string {
	if x != nil && x.DatetimeCol != nil {
		return *x.DatetimeCol
	}
	return ""
}

func (x *SampleData) GetGeographyCol() string {
	if x != nil && x.GeographyCol != nil {
		return *x.GeographyCol
	}
	return ""
}

func (x *SampleData) GetNumericCol() string {
	if x != nil && x.NumericCol != nil {
		return *x.NumericCol
	}
	return ""
}

func (x *SampleData) GetBignumericCol() string {
	if x != nil && x.BignumericCol != nil {
		return *x.BignumericCol
	}
	return ""
}

func (x *SampleData) GetTimeCol() string {
	if x != nil && x.TimeCol != nil {
		return *x.TimeCol
	}
	return ""
}

func (x *SampleData) GetTimestampCol() int64 {
	if x != nil && x.TimestampCol != nil {
		return *x.TimestampCol
	}
	return 0
}

func (x *SampleData) GetInt64List() []int64 {
	if x != nil {
		return x.Int64List
	}
	return nil
}

func (x *SampleData) GetStructCol() *SampleStruct {
	if x != nil {
		return x.StructCol
	}
	return nil
}

func (x *SampleData) GetStructList() []*SampleStruct {
	if x != nil {
		return x.StructList
	}
	return nil
}

func (x *SampleData) GetRowNum() int64 {
	if x != nil && x.RowNum != nil {
		return *x.RowNum
	}
	return 0
}

var File_sample_data_proto protoreflect.FileDescriptor

var file_sample_data_proto_rawDesc = []byte{
	0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x2e, 0x0a, 0x0c, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x12, 0x1e, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x75, 0x62, 0x49, 0x6e, 0x74, 0x43, 0x6f,
	0x6c, 0x22, 0xbc, 0x04, 0x0a, 0x0a, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x19, 0x0a, 0x08, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x62, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61,
	0x74, 0x36, 0x34, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x66,
	0x6c, 0x6f, 0x61, 0x74, 0x36, 0x34, 0x43, 0x6f, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x43, 0x6f, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6c,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x67, 0x65, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79,
	0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x67, 0x65, 0x6f, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x79, 0x43, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x69, 0x67,
	0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x62, 0x69, 0x67, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6c,
	0x12, 0x19, 0x0a, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x43, 0x6f, 0x6c,
	0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x0d,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x09, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6e,
	0x75, 0x6d, 0x18, 0x10, 0x20, 0x02, 0x28, 0x03, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x4e, 0x75, 0x6d,
	0x42, 0x53, 0x5a, 0x51, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2d, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x2f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x70, 0x72, 0x6f, 0x74, 0x6f,
}

var (
	file_sample_data_proto_rawDescOnce sync.Once
	file_sample_data_proto_rawDescData = file_sample_data_proto_rawDesc
)

func file_sample_data_proto_rawDescGZIP() []byte {
	file_sample_data_proto_rawDescOnce.Do(func() {
		file_sample_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_sample_data_proto_rawDescData)
	})
	return file_sample_data_proto_rawDescData
}

var file_sample_data_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_sample_data_proto_goTypes = []interface{}{
	(*SampleStruct)(nil), // 0: exampleproto.SampleStruct
	(*SampleData)(nil),   // 1: exampleproto.SampleData
}
var file_sample_data_proto_depIdxs = []int32{
	0, // 0: exampleproto.SampleData.struct_col:type_name -> exampleproto.SampleStruct
	0, // 1: exampleproto.SampleData.struct_list:type_name -> exampleproto.SampleStruct
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_sample_data_proto_init() }
func file_sample_data_proto_init() {
	if File_sample_data_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sample_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampleStruct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sample_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampleData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sample_data_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sample_data_proto_goTypes,
		DependencyIndexes: file_sample_data_proto_depIdxs,
		MessageInfos:      file_sample_data_proto_msgTypes,
	}.Build()
	File_sample_data_proto = out.File
	file_sample_data_proto_rawDesc = nil
	file_sample_data_proto_goTypes = nil
	file_sample_data_proto_depIdxs = nil
}
