
#ifndef	NP2_I386HAX_HAXCORE_H__
#define	NP2_I386HAX_HAXCORE_H__

#if defined(SUPPORT_IA32_HAXM)

#ifdef __cplusplus
extern "C" {
#endif
	
#if defined(_WIN32)
typedef struct {
	UINT8	available; // HAXMgp\
	UINT8	enable; // HAXML
	UINT8	emumode; // LCPUő֏
	HANDLE	hDevice; // HAXMfoCX̃nh
	HANDLE	hVMDevice; // HAXMz}VfoCX̃nh
	HANDLE	hVCPUDevice; // HAXMzCPUfoCX̃nh
	UINT32	vm_id; // HAXMz}VID
	HAX_TUNNEL_INFO	tunnel; // HAXMz}VƂ̃f[^Ƃptunnel

	UINT8 bioshookenable; // fobOWX^ɂG~[VBIOStbNL
} NP2_HAX;
typedef struct {
	HAX_VCPU_STATE	state; // HAXMzCPŨWX^
	HAX_FX_LAYOUT	fpustate; // HAXMzCPUFPUWX^
	HAX_MSR_DATA	msrstate; // HAXMzCPUMSR
	HAX_VCPU_STATE	default_state; // HAXMzCPŨWX^iftHglj
	HAX_FX_LAYOUT	default_fpustate; // HAXMzCPUFPUWX^iftHglj
	HAX_MSR_DATA	default_msrstate; // HAXMzCPUMSRiftHglj
	UINT8 update_regs; // vWX^XV
	UINT8 update_segment_regs; // vZOgWX^XV
	UINT8 update_fpu; // vFPUWX^XV

	UINT8 irq_req[256]; // 荞ݑҋ@obt@BC̊荞݃xN^i[
	UINT8 irq_reqidx_cur; // 荞ݑҋ@obt@̓ǂݎʒu
	UINT8 irq_reqidx_end; // 荞ݑҋ@obt@݈̏ʒu
} NP2_HAX_STAT;
typedef struct {
	UINT8 running; // HAXM CPUstO

	// ^C~Opiperformance countergpj
	LARGE_INTEGER lastclock; // ÕNbN
	LARGE_INTEGER clockpersec; // 1bNbN
	LARGE_INTEGER clockcount; // ݂̃NbN

	UINT8 I_ratio;

	UINT32 lastA20en; // OA20CL
	UINT32 lastITFbank; // OITFoNgpĂ
	UINT32 lastVGA256linear; // O256F[h̃jAAhXgpĂ
	UINT32 lastVRAMMMIO; // VRAM̃AhXMMIO[h
	
	UINT8 hurryup; // ^C~OxĂ̂ŋ}ׂ

	UINT8 hltflag; // HLT߂Œ~tO

	UINT8 allocwabmem; // WAB vramptro^ς݂Ȃ1

	UINT8 ready_for_reset;
} NP2_HAX_CORE;

#define NP2HAX_I_RATIO_MAX	1024

extern	NP2_HAX			np2hax;
extern	NP2_HAX_STAT	np2haxstat;
extern	NP2_HAX_CORE	np2haxcore;

#endif

#ifdef __cplusplus
}
#endif

UINT8 i386hax_check(void); // HAXMgp\`FbN
void i386hax_initialize(void); // HAXM
void i386hax_createVM(void); // HAXMz}V쐬
void i386hax_resetVMMem(void); // HAXMz}VZbgij
void i386hax_resetVMCPU(void); // HAXMz}VZbgiCPUj
void i386hax_disposeVM(void); // HAXMz}Vj
void i386hax_deinitialize(void); // HAXM

void i386hax_vm_exec(void); // HAXMzCPU̎s

void i386hax_vm_allocmemory(void); // ̈o^i{̈j
void i386hax_vm_allocmemoryex(UINT8 *vramptr, UINT32 size); // ̈o^iėpj

// QXgAhX(Guest Physical Address; GPA)ɃzXg̉zAhX(Host Virtual Address; HVA)蓖
void i386hax_vm_setmemory(void); // 00000h`BFFFFh܂
void i386hax_vm_setbankmemory(void); // A0000h`F7FFFh܂
void i386hax_vm_setitfmemory(UINT8 isitfbank); // F8000h`FFFFFh܂
void i386hax_vm_sethmemory(UINT8 a20en); // 100000h`10FFFFh܂
void i386hax_vm_setextmemory(void); // 110000hȍ~
void i386hax_vm_setvga256linearmemory(void); // 0xF00000`0xF80000
//void i386hax_vm_setwabmemory(UINT8 *vramptr, UINT32 addr, UINT32 size);

// ėp ̈抄蓖
void i386hax_vm_setmemoryarea(UINT8 *vramptr, UINT32 addr, UINT32 size);
void i386hax_vm_removememoryarea(UINT8 *vramptr, UINT32 addr, UINT32 size);

void ia32hax_copyregHAXtoNP2(void);
void ia32hax_copyregNP2toHAX(void);

#endif

#endif	/* !NP2_I386HAX_HAXCORE_H__ */
