
	ORG		100h
	USE16
	CPU		186


%include	'np2tool.inc'
%include	'hostdrv.inc'

START:			jmp		short keep_addr
id				db		'host_drv'

int2f:			cmp		ah, 11h
				jne		short i2f_chain
				cmp		al, 2eh
				ja		short i2f_chain
				pusha
				push	ds
				push	es
				mov		bp, sp

				mov		cl, al
				shr		al, 3
				and		cl, 7
				inc		cl
				mov		bx, i2f_nochkbmp
				db		FIXCS
				xlat
				rcr		al, cl
				jc		short i2f_callnp2
				mov		ax, 1223h	; check char dev
				int		2fh

i2f_callnp2:	pushf
				mov		ax, 1218h
				int		2fh
				popf
				mov		bx, si
				mov		si, intr_hostdrv
				mov		dx, NP2PORT
				mov		cx, 12
				cld
				db		FIXCS
				rep		outsb
				jnc		short i2f_end
				pushf
				mov		ax, 120ch	; set sft owner
				int		2fh
				popf
i2f_end:		pop		es
				pop		ds
				popa
				jne		short i2f_chain
				iret

i2f_chain:		db		0eah
org_int2f		dd		0

inf				db		0
				dw		0
				dw		0
				dw		0

;						76543210   fedcba98
i2f_nochkbmp	db		11010101b, 00111111b
				db		00110101b, 11110111b
				db		11111111b, 10111111b

intr_hostdrv	db		'intr_hostdrv'


; ----

keep_addr:		jmp		short main

errexit_lv2:	sti
				mov		ah, 9
				int		21h
				mov		dx, bx
errexit_lv1:	sti
				mov		ah, 9
				int		21h
				mov		dx, str_crlf
				mov		ah, 9
				int		21h
				mov		ax, 4c01h
				int		21h

main:			cld ; JE^CNgw
				push	cs ; CSX^bN
				pop		ds ; X^bNDSɃZbg(CS -> DS)
				mov		ah, 9 ; $ I[\
				mov		dx, title_msg ; ^Cg
				int		21h ; s

				; @`FbN
				cli ; 荞݋֎~
				call	np2_check ; np2mF
				mov		dx, macerr_msg ; @G[bZ[Wp
				jne		short errexit_lv2 ; G[ȂI

				mov		ax, 352fh ; ݂INT 2Fh ̃xN^擾
				int		21h ; s
				mov		si, id ; IDHOSTDRV̂̂mF
				mov		di, si
				mov		cl, 4 ; WORDx4܂8r
				repe cmpsw ; r
				jne		short stay ; 풓֔
				jmp		release ; ɏ풓ς


stay:			mov		si, 0080h ; R}hC擾
				mov		dx, usage_msg ; R}hCG[bZ[Wp
				xor		cx, cx
				lodsb
				add		cl, al ; ̒@-> CL
				je		short stay_error ; w肪Ȃi0ĵŃG[
cmdlnchk:		lodsb
				cmp		al, 20h
				ja		short drvcheck ; Xy[XȊOꂽ珈s
				loop	cmdlnchk
stay_error:		jmp		errexit_lv1 ; Xy[XȂ̂ŃG[

drvcheck:		and		al, 0dfh ;  -> 啶֕ϊ
				sub		al, 'A' ; A珇0, 1, 2, ...
				cmp		al, 26 ; ZȂG[
				mov		dx, drverr0_msg ; hCuG[bZ[W
				jae		short stay_error ; G[ȂI

				mov		[inf + HDRVIF.drive_no], al ; hCuԍۑ
				mov		ah, 30h ; DOSo[W擾
				int		21h ; s
				mov		[inf + HDRVIF.dosver], ax ; DOSo[Wۑ
				xchg	al, ah
				cmp		ax, 030ah ; DOSo[W3.1ȏォH
				mov		dx, doserr_msg ; DOSo[WG[bZ[W
				jc		short stay_error ; DOSo[WʖڂȂG[
				mov		ax, 1100h					; HOSTDRV풓O`FbN
				int		2fh
				cmp		ax, 1 ; not installed, not OK to install 𔻒
				mov		dx, cntsty_msg ; CXg[sG[bZ[W
				je		short stay_error ; G[ȂI
				mov		ax, 5d06h					; SDAAhX擾
				int		21h
				mov		[cs:inf + HDRVIF.sda_off], si ; SDA offsetۑ
				mov		[cs:inf + HDRVIF.sda_seg], ds ; SDA segmentۑ
				push	cs
				pop		ds

				; o[W`FbN
				mov		si, stay_param
				call	sendnp2port ; NULL܂őicheck_hostdrvj
				call	checknp2port ; NULL܂Ŕri0.74Ɣrj
				mov		dx, np2err_msg ; o[WG[bZ[W
				jne		short stay_error ; G[ȂI

				; assign_cds CDS̕Kvڂi[
				call	getcds
				mov		dx, drverr1_msg
				jc		short stay_error ; hCuԍǗOG[
				test	byte [es:di + CDS.flag + 1], 0c0h
				mov		dx, drverr2_msg
				jne		short stay_error ; hCuԍgpG[

				; VvgRT|[gmF@}EgO͐VvgRLɕpokԂ
				mov		si, enable_newp
				call	sendnp2port ; NULL܂őisetn_hostdrvj
				call	checknp2port ; NULL܂ŔripokƔrj
				jne		short protocol_old ; G[Ȃ狌vgR
				
				; VvgR
				mov		al, [inf + HDRVIF.drive_no]
				add		al, 'A'
				mov		byte [stay_type2 + 1], al
				mov		si, stay_type2 ; SIVvgRpɐݒ
				jmp		protocol_end
				
				; vgR
protocol_old:	mov		si, stay_type1 ; SIvgRpɐݒ
				
				; CDSݒ̑
protocol_end:	xor		cx, cx
				lodsb
				mov		cl, al
				or		word [es:di + CDS.flag], 0c080h
				mov		[es:di + CDS.root], cx
				rep movsb
				mov		si, stay_param2
				movsw

				mov		bx, inf
				mov		di, cs
				xor		cx, cx
				mov		es, cx
				xchg	bx, [es:0600h]
				xchg	di, [es:0602h]
				call	sendnp2port
				call	checknp2port
				mov		[es:0600h], bx
				mov		[es:0602h], di
				jne		short ass_err

				mov		ax, 352fh
				int		21h
				mov		[org_int2f + 0], bx
				mov		[org_int2f + 2], es
				mov		ax, 252fh
				mov		dx, int2f
				int		21h

				mov		cl, 13
				mov		dx, str_user
				mov		ax, 5e01h
				int		21h

				; VvgRL
				push	si
				mov		si, enable_newp
				call	sendnp2port ; NULL܂őisetn_hostdrvj
				call	checknp2port ; NULL܂ŔripokƔrjsĂ
				jne		short protocol_skip ; G[Ȃ狌vgR
				mov		ah, 9 ; $ I[\
				mov		dx, newpro_msg ; VvgR\
				int		21h
protocol_skip:	pop		si
				
				sti
				mov		al, [inf + HDRVIF.drive_no] ; hCuԍ -> AL
				add		byte [sty_drive], al ; hCu
				mov		ah, 9 ; $ I[\
				mov		dx, si ; hCu\
				int		21h
				
				mov		ax, 3100h
				mov		dx, keep_addr + 15
				mov		cl, 4
				shr		dx, cl
				int		21h

ass_err:		call	getcds
				mov		word [es:di + CDS.flag], 0
				mov		dx, styerr_msg
				jmp		errexit_lv1



release:		mov		ax, 252fh
				lds		dx, [es:org_int2f]
				int		21h
				push	es
				pop		ds
				call	getcds
				mov		word [es:di + CDS.flag], 0
				mov		es, [002ch]
				mov		ah, 49h
				int		21h
				push	ds
				pop		es
				mov		ah, 49h
				int		21h
				push	cs
				pop		ds
				mov		si, rel_param
				call	sendnp2port
				sti
				mov		ah, 9
				mov		dx, si
				int		21h
				mov		ax, 4c00h
				int		21h



getcds:			mov		ax, 5200h	; get lol addr
				int		21h
				mov		al, [inf + HDRVIF.drive_no]
				cmp		al, [es:bx + LOL.lastdrv]
				jae		short gcds_err
				les		di, [es:bx + LOL.cds]
				mov		ah, CDS.size
				cmp		byte [inf + HDRVIF.dosver], 3
				je		short gcds_calc
				add		ah, 7
gcds_calc:		mul		ah
				add		di, ax
				ret
gcds_err:		stc
				ret


%include	'np2tool.x86'

title_msg		db	"host-drive driver for np2+dos ("
				db	VERSION_ID
				db	 ")"
str_crlf		db	13, 10, "$"
str_user		db	"NekoProjectII  "


stay_param		db	13, "check_hostdrv"
				db	 5, "0.74",0
stay_type1		db	 9, "\\HOSTDRV" ; np2݊
stay_type2		db	 2, "A:" ; VvgR
stay_param2		db		"\", 0
				db	12, "open_hostdrv"
				db	 3, "ok",0
				db	"assigned host-drive to "
sty_drive		db	"A:", 13, 10, "$"

enable_newp		db	12, "setn_hostdrv"
				db	 4, "pok",0


rel_param		db	13, "close_hostdrv"
				db	"unassigned", 13, 10, "$"


usage_msg		db	"usage: hostdrv.com [drive letter]$"
macerr_msg		db	"Illegal hardware - $"
doserr_msg		db	"unsupported dos version$"
np2err_msg		db	"unsupported np2 version$"
cntsty_msg		db	"cannot stay$"
drverr0_msg		db	"drive is bad$"
drverr1_msg		db	"drive higher than last drive$"
drverr2_msg		db	"drive already assigned$"
styerr_msg		db	"cannot assign$"
newpro_msg		db	"new protocol enabled"
				db	13, 10, "$"

	ends

