#include <ntddk.h>
#include "miniifs.h"
#include "minisop.h"
#include "irplock.h"

// NonPagedPoolւ̃Rs[ł͂Ȃy[WbNg
#define USE_FAST_IRPSTACKLOCK

#define HOSTDRVNT_IO_ADDR	0x7EC
#define HOSTDRVNT_IO_CMD	0x7EE

// ̃foCXhCõfoCX
#define DEVICE_NAME     L"\\Device\\HOSTDRV"
#define DOS_DEVICE_NAME L"\\DosDevices\\HOSTDRV"
#define DOS_DRIVE_NAME  L"\\DosDevices\\Z:"

#define PENDING_IRP_MAX	256

#define HOSTDRVNTOPTIONS_NONE				0x0
#define HOSTDRVNTOPTIONS_REMOVABLEDEVICE	0x1
#define HOSTDRVNTOPTIONS_USEREALCAPACITY	0x2
#define HOSTDRVNTOPTIONS_USECHECKNOTIFY		0x4
#define HOSTDRVNTOPTIONS_AUTOMOUNTDRIVE		0x8
#define HOSTDRVNTOPTIONS_DISKDEVICE			0x10

#define HOSTDRVNT_VERSION		4

// G~[^Ƃ̒ʐMp
typedef struct tagHOSTDRV_INFO {
    PIO_STACK_LOCATION stack; // IoGetCurrentIrpStackLocation(Irp)Ŏ擾f[^ւ̃AhX
    PIO_STATUS_BLOCK status; // Irp->IoStatusւ̃AhX
    PVOID systemBuffer; // QXgOSG~[^ւ̃obt@
    ULONG deviceFlags; // irpSp->DeviceObject->Flags̒l
    PVOID outBuffer; // G~[^QXgOSւ̃obt@
    PVOID sectionObjectPointer; // irpSp->FileObject->SectionObjectPointerւ̃AhX
    ULONG version; // G~[^ʐMo[W
    ULONG pendingListCount; // ҋ@pIRP̃Xg̗vf
    PIRP  *pendingIrpList; // ҋ@pIRP̃Xgւ̃AhX
    ULONG *pendingAliveList; // ҋ@ptOiLt@CIuWFNgCfbNXj̃Xgւ̃AhX
    union{
    	LONG pendingIndex; // STATUS_PENDINĜƂAǂ̃CfbNXɑҋ@pIRPǉ邩\iLZbgj
    	LONG pendingCompleteCount; // STATUS_PENDINGȊO̎Aҋ@̂̐\iLZbgj
    } pending;
    ULONG hostdrvNTOptions; // HOSTDRV for NTIvV
} HOSTDRV_INFO, *PHOSTDRV_INFO;
typedef struct tagHOSTDRV_NOTIFYINFO {
    ULONG version; // G~[^ʐMo[W
    ULONG pendingListCount; // ҋ@pIRP̃Xg̗vf
    PIRP  *pendingIrpList; // ҋ@pIRP̃Xgւ̃AhX
    ULONG *pendingAliveList; // ҋ@ptOiLt@CIuWFNgCfbNXj̃Xgւ̃AhX
    union{
    	LONG pendingCompleteCount; // ҋ@̂̐\iLZbgj
    } pending;
} HOSTDRV_NOTIFYINFO, *PHOSTDRV_NOTIFYINFO;

// irpSp->FileObject->FsContext֊i[
// QlFirpSp->FileObject->FsContext֓KID̂NGBFXȂȂB
// KExAllocatePoolWithTag(NonPagedPool, `Ŋ蓖ĂłKvB
// [Undocumented] \̃TCY͏ȂƂ64byteȂƑʖځH
// ȂOSߑł͈̔͊OQƂIRQL_NOT_LESS_OR_EQUALpBǂ܂łΈS͕sB
// FSRTL_COMMON_FCB_HEADER\̂̍ŏɊ܂߂Ȃ΂ȂȂƂK{̂悤ɂv܂B
typedef struct tagHOSTDRV_FSCONTEXT {
	FSRTL_COMMON_FCB_HEADER header; // OSĝŐGĂ͂ȂB32bitł40byte
    ULONG fileIndex; // G~[^{̂Ǘt@CID
    ULONG reserved[5]; // \
} HOSTDRV_FSCONTEXT, *PHOSTDRV_FSCONTEXT;

// O[oɊǗϐQ
static FAST_MUTEX g_Mutex; // I/O̔rbNp
static PIRP g_pendingIrpList[PENDING_IRP_MAX] = {0}; // I/Oҋ@pIRP̃Xg
static ULONG g_pendingAliveList[PENDING_IRP_MAX] = {0}; // I/Oҋ@ptÕXg
static ULONG g_hostdrvNTOptions = HOSTDRVNTOPTIONS_NONE; // HOSTDRV for NTIvV
static ULONG g_checkNotifyInterval = 10; // zXg̃t@CVXeύXʒmbԊuŃ`FbN邩
static KTIMER g_checkNotifyTimer = {0}; // zXg̃t@CVXeύXʒmĎ^C}[
static KDPC g_checkNotifyTimerDpc = {0}; // zXg̃t@CVXeύXʒmĎ^C}[DPC
static WORK_QUEUE_ITEM g_RescheduleTimerWorkItem = {0}; // zXg̃t@CVXeύXʒmĎ^C}[ċNp
static int g_checkNotifyTimerEnabled = 0; // zXg̃t@CVXeύXʒmĎ^C}[Jn
static ULONG g_pendingCounter = 0; // t@CVXeĎSTATUS_PENDINGԂ̂̂̐
static WCHAR g_autoMountDriveLetter = 0; // }Eg̃hCu^[B0̏ꍇZ珇ɎgꏊTĊ蓖āB

// ֐`
NTSTATUS DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath);
NTSTATUS HostdrvDispatch(IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp);
VOID HostdrvUnload(IN PDRIVER_OBJECT DriverObject);
VOID HostdrvCancelRoutine(PDEVICE_OBJECT DeviceObject, PIRP Irp);
VOID HostdrvTimerDpcRoutine(IN PKDPC Dpc, IN PVOID DeferredContext, IN PVOID SystemArgument1, IN PVOID SystemArgument2);
VOID HostdrvRescheduleTimer(IN PVOID Context);

// WXgDWORDlǂ
ULONG HostdrvReadDWORDReg(HANDLE hKey, WCHAR *valueName) {
	NTSTATUS status;
	UNICODE_STRING valueNameUnicode;
	ULONG resultLength;
	PKEY_VALUE_PARTIAL_INFORMATION pInfo;
	
	RtlInitUnicodeString(&valueNameUnicode, valueName);
	status = ZwQueryValueKey(hKey, &valueNameUnicode, KeyValuePartialInformation, NULL, 0, &resultLength);
	if (status != STATUS_BUFFER_TOO_SMALL && status != STATUS_BUFFER_OVERFLOW) {
	    return 0;
	}
	pInfo = ExAllocatePoolWithTag(PagedPool, resultLength, 'prmT');
	if (!pInfo) {
	    return 0;
	}
	status = ZwQueryValueKey(hKey, &valueNameUnicode, KeyValuePartialInformation, pInfo, resultLength, &resultLength);
	if (NT_SUCCESS(status) && pInfo->Type == REG_DWORD) {
    	ULONG retValue = *(ULONG *)pInfo->Data;
		ExFreePool(pInfo);
    	return retValue;
	}
	ExFreePool(pInfo);
	
	return 0;
}
// WXg̃hCu킷REG_SZǂ
WCHAR HostdrvReadDriveLetterReg(HANDLE hKey, WCHAR *valueName) {
	NTSTATUS status;
	UNICODE_STRING valueNameUnicode;
	ULONG resultLength;
	PKEY_VALUE_PARTIAL_INFORMATION pInfo;
	
	RtlInitUnicodeString(&valueNameUnicode, valueName);
	status = ZwQueryValueKey(hKey, &valueNameUnicode, KeyValuePartialInformation, NULL, 0, &resultLength);
	if (status != STATUS_BUFFER_TOO_SMALL && status != STATUS_BUFFER_OVERFLOW) {
	    return 0;
	}
	pInfo = ExAllocatePoolWithTag(PagedPool, resultLength, 'prmT');
	if (!pInfo) {
	    return 0;
	}
	status = ZwQueryValueKey(hKey, &valueNameUnicode, KeyValuePartialInformation, pInfo, resultLength, &resultLength);
	if (NT_SUCCESS(status) && pInfo->Type == REG_SZ && pInfo->DataLength == 2 * sizeof(WCHAR)) { // NULL܂ރoCg
    	WCHAR retValue = ((WCHAR *)(pInfo->Data))[0];
		ExFreePool(pInfo);
    	return retValue;
	}
	ExFreePool(pInfo);
	
	return 0;
}

// IvṼWXgL[`FbN
VOID HostdrvCheckOptions(IN PUNICODE_STRING RegistryPath) {
	OBJECT_ATTRIBUTES attributes;
	HANDLE hKey;
	NTSTATUS status;

	InitializeObjectAttributes(&attributes, RegistryPath, OBJ_CASE_INSENSITIVE, NULL, NULL);
	
	status = ZwOpenKey(&hKey, KEY_READ, &attributes);
	if (!NT_SUCCESS(status)) {
	    return;
	}
	
	if (HostdrvReadDWORDReg(hKey, L"IsDiskDevice")){
		g_hostdrvNTOptions |= HOSTDRVNTOPTIONS_DISKDEVICE;
	}
	if (HostdrvReadDWORDReg(hKey, L"IsRemovableDevice")){
		g_hostdrvNTOptions |= HOSTDRVNTOPTIONS_REMOVABLEDEVICE;
	}
	if (HostdrvReadDWORDReg(hKey, L"UseRealCapacity")){
		g_hostdrvNTOptions |= HOSTDRVNTOPTIONS_USEREALCAPACITY;
	}
	if (HostdrvReadDWORDReg(hKey, L"UseCheckNotify")){
		g_hostdrvNTOptions |= HOSTDRVNTOPTIONS_USECHECKNOTIFY;
	}
	g_checkNotifyInterval = HostdrvReadDWORDReg(hKey, L"CheckNotifyInterval");
	if (g_checkNotifyInterval <= 0){
		g_checkNotifyInterval = 5; // ftHgi5bjɂ
	}
	if (g_checkNotifyInterval > 60){
		g_checkNotifyInterval = 60; // ő60bɂ
	}
	if (HostdrvReadDWORDReg(hKey, L"AutoMount")){
		g_hostdrvNTOptions |= HOSTDRVNTOPTIONS_AUTOMOUNTDRIVE;
	}
	g_autoMountDriveLetter = HostdrvReadDriveLetterReg(hKey, L"AutoMountDriveLetter");
	if('a' <= g_autoMountDriveLetter && g_autoMountDriveLetter <= 'z'){
		// 啶Ƃ
		g_autoMountDriveLetter = g_autoMountDriveLetter - 'a' + 'A';
	}
	if(!('A' <= g_autoMountDriveLetter && g_autoMountDriveLetter <= 'Z')){
		// Ȃ̂Ŏ蓖ĂƂ
		g_autoMountDriveLetter = 0;
	}
	
	ZwClose(hKey);
}

VOID HostdrvStartTimer()
{
	LARGE_INTEGER dueTime;
	
    if (g_checkNotifyTimerEnabled) {
        return;
    }
    
	g_checkNotifyTimerEnabled = 1;
	
	dueTime.QuadPart = (LONGLONG)(-(LONG)g_checkNotifyInterval * 1000 * 10000);
	KeSetTimer(&g_checkNotifyTimer, dueTime, &g_checkNotifyTimerDpc);
}

VOID HostdrvStopTimer()
{
    if (!g_checkNotifyTimerEnabled) {
        return;
    }
    
	KeCancelTimer(&g_checkNotifyTimer);
	
	g_checkNotifyTimerEnabled = 0;
}

NTSTATUS ReserveIoPortRange(PDRIVER_OBJECT DriverObject)
{
    PCM_PARTIAL_RESOURCE_DESCRIPTOR pResourceDescriptor;
    PCM_PARTIAL_RESOURCE_LIST pPartialResourceList;
    PCM_FULL_RESOURCE_DESCRIPTOR pFullResourceDescriptor;
    PCM_RESOURCE_LIST pResourceList;
    ULONG listSize;
    UNICODE_STRING className;

    BOOLEAN conflictDetected = FALSE;
    NTSTATUS status;
    
    listSize = sizeof(CM_RESOURCE_LIST) + sizeof(CM_PARTIAL_RESOURCE_DESCRIPTOR);
    pResourceList = ExAllocatePoolWithTag(PagedPool, listSize, 'resl');
    if(!pResourceList){
    	return STATUS_INSUFFICIENT_RESOURCES;
    }
    RtlZeroMemory(pResourceList, listSize);
    pResourceList->Count = 1;

	pFullResourceDescriptor = &(pResourceList->List[0]);
    pFullResourceDescriptor->InterfaceType = Internal;
    pFullResourceDescriptor->BusNumber = 0;
    
    pPartialResourceList = &(pFullResourceDescriptor->PartialResourceList);
    pPartialResourceList->Version = 1;
    pPartialResourceList->Revision = 1;
    pPartialResourceList->Count = 2;
    
    pResourceDescriptor = &(pPartialResourceList->PartialDescriptors[0]);
    pResourceDescriptor->Type = CmResourceTypePort;
    pResourceDescriptor->ShareDisposition = CmResourceShareDriverExclusive;
    pResourceDescriptor->Flags = CM_RESOURCE_PORT_IO | CM_RESOURCE_PORT_16_BIT_DECODE;
    pResourceDescriptor->u.Port.Start.QuadPart = HOSTDRVNT_IO_ADDR;
    pResourceDescriptor->u.Port.Length = 1;
    
    pResourceDescriptor = &(pPartialResourceList->PartialDescriptors[1]);
    pResourceDescriptor->Type = CmResourceTypePort;
    pResourceDescriptor->ShareDisposition = CmResourceShareDriverExclusive;
    pResourceDescriptor->Flags = CM_RESOURCE_PORT_IO | CM_RESOURCE_PORT_16_BIT_DECODE;
    pResourceDescriptor->u.Port.Start.QuadPart = HOSTDRVNT_IO_CMD;
    pResourceDescriptor->u.Port.Length = 1;
    
    // \[Xgp̕
	RtlInitUnicodeString(&className, L"LegacyDriver");
    status = IoReportResourceUsage(
        &className,           // DriverClassName
        DriverObject,         // OwningDriverObject
        pResourceList,        // ResourceList
        listSize,             // ResourceListSize
        NULL,                 // PhysicalDeviceObject
        NULL,                 // ConflictList
        0,                    // ConflictCount
        FALSE,                // ArbiterRequest
        &conflictDetected     // ConflictDetected
    );
    
	ExFreePool(pResourceList);

    if (!NT_SUCCESS(status)) {
        return status;
    }

    if (conflictDetected) {
        return STATUS_CONFLICTING_ADDRESSES;
    }

    return STATUS_SUCCESS;
}

// foCXhCõGg|Cg
NTSTATUS DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath) {
    UNICODE_STRING deviceNameUnicodeString, dosDeviceNameUnicodeString;
    PDEVICE_OBJECT deviceObject = NULL;
    DEVICE_TYPE deviceType = FILE_DEVICE_NETWORK_FILE_SYSTEM;
    ULONG deviceCharacteristics = FILE_DEVICE_IS_MOUNTED;
    NTSTATUS status;
    int i;
    
    // I/O|[gg邩mF
    status = ReserveIoPortRange(DriverObject);
    if (!NT_SUCCESS(status)) {
        return status;
    }

    // hostdrv for NTΉȈՃ`FbN
    if(READ_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR) != 98 || READ_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD) != 21){
        return STATUS_NO_SUCH_DEVICE;
	}
	
    // hostdrv for NTZbg
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)0);
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)0);
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)0);
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)0);
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'H');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'D');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'R');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'9');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'8');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'0');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'1');

    // rbN@݂̂Ŕj͂Ȃ
    ExInitializeFastMutex(&g_Mutex);
    
    // IvV`FbN
    HostdrvCheckOptions(RegistryPath);
    
    // foCX^CvȂǂ̐ݒ
    if(g_hostdrvNTOptions & HOSTDRVNTOPTIONS_REMOVABLEDEVICE){
    	// [oufoCX̐U郂[h
    	deviceType = FILE_DEVICE_DISK_FILE_SYSTEM;
    	deviceCharacteristics |= FILE_REMOVABLE_MEDIA;
    }else if(g_hostdrvNTOptions & HOSTDRVNTOPTIONS_DISKDEVICE){
    	// [JfBXN̐U郂[h
    	deviceType = FILE_DEVICE_DISK_FILE_SYSTEM;
    }else{
    	// lbg[Nt@CVXe̐U郂[h
    	deviceType = FILE_DEVICE_NETWORK_FILE_SYSTEM;
    	deviceCharacteristics |= FILE_REMOTE_DEVICE;
    }
    
    // foCX쐬@[JfBXN̐UȂFILE_DEVICE_DISK_FILE_SYSTEM
    RtlInitUnicodeString(&deviceNameUnicodeString, DEVICE_NAME);
    status = IoCreateDevice(DriverObject, 0, &deviceNameUnicodeString,
                            deviceType, deviceCharacteristics, FALSE, &deviceObject);
    if (!NT_SUCCESS(status)) {
        return status;
    }

    // foCXDOSo^@\\.\HOSTDRV̂悤ɃANZXł
    RtlInitUnicodeString(&dosDeviceNameUnicodeString, DOS_DEVICE_NAME);
    status = IoCreateSymbolicLink(&dosDeviceNameUnicodeString, &deviceNameUnicodeString);
    if (!NT_SUCCESS(status)) {
        IoDeleteDevice(deviceObject);
        return status;
    }
    
    // hCu蓖Ă̏ꍇA蓖
    if(g_hostdrvNTOptions & HOSTDRVNTOPTIONS_AUTOMOUNTDRIVE){
		UNICODE_STRING dosDriveNameUnicodeString;
    	WCHAR dosDriveName[] = DOS_DRIVE_NAME;
		RtlInitUnicodeString(&dosDriveNameUnicodeString, dosDriveName);
    	if(g_autoMountDriveLetter== 0){
    		// Ŏg镶T
    		for(g_autoMountDriveLetter='Z';g_autoMountDriveLetter>='A';g_autoMountDriveLetter--){
    			dosDriveNameUnicodeString.Buffer[12] = g_autoMountDriveLetter;
	    		status = IoCreateSymbolicLink(&dosDriveNameUnicodeString, &deviceNameUnicodeString);
    			if (NT_SUCCESS(status)) {
    				break;
    			}
    		}
    		if(g_autoMountDriveLetter < 'A'){
    			// 󂫂Ȃ̂Ŋ蓖ĂłȂ
    			g_autoMountDriveLetter = 0;
    		}
    	}else{
    		// Œ蕶w@gȂĂG[ɂ͂Ȃ
    		dosDriveNameUnicodeString.Buffer[12] = g_autoMountDriveLetter;
	    	status = IoCreateSymbolicLink(&dosDriveNameUnicodeString, &deviceNameUnicodeString);
		    if (!NT_SUCCESS(status)) {
		    	// 蓖Ďs
		        g_autoMountDriveLetter = 0;
		    }
    	}
    }

    // foCXIRP֐o^@vfԍeIRP_MJ_`̔ԍɑΉB
    // SG~[^{̂ɓ̂őSɓ֐蓖
    for (i = 0; i < IRP_MJ_MAXIMUM_FUNCTION; i++) {
        DriverObject->MajorFunction[i] = HostdrvDispatch;
    }

    // hCȍIo^
    DriverObject->DriverUnload = HostdrvUnload;
    
    // LbVł}bvgt@Cg悤ɂWORKAROUNDLbV
    MiniSOP_InitializeCache(DriverObject);
    
    // ̑ǉtOݒ
    deviceObject->Flags |= DO_BUFFERED_IO; // f[^󂯓nSystemBuffer{ƂHw肵ĂŗƂ͗CB
    
    if(g_hostdrvNTOptions & HOSTDRVNTOPTIONS_USECHECKNOTIFY){
    	KeInitializeTimer(&g_checkNotifyTimer);
		KeInitializeDpc(&g_checkNotifyTimerDpc, HostdrvTimerDpcRoutine, NULL);
        ExInitializeWorkItem(&g_RescheduleTimerWorkItem, HostdrvRescheduleTimer, NULL);
	}

    KdPrint(("Hostdrv: Loaded successfully\n"));
    return STATUS_SUCCESS;
}

VOID HostdrvUnload(IN PDRIVER_OBJECT DriverObject) {
    UNICODE_STRING dosDeviceNameUnicodeString;
    int i;
    
    // ҋ@IRPSLZ
    for (i = 0; i < PENDING_IRP_MAX; i++) {
        if (g_pendingIrpList[i] != NULL) {
    		KIRQL oldIrql;
        	PIRP Irp = g_pendingIrpList[i];
		    g_pendingIrpList[i] = NULL;
		    g_pendingAliveList[i] = 0;
        	IoAcquireCancelSpinLock(&oldIrql);
        	if(Irp->CancelRoutine){
				Irp->CancelRoutine = NULL;
    			IoReleaseCancelSpinLock(Irp->CancelIrql);
			    Irp->IoStatus.Status = STATUS_CANCELLED;
			    Irp->IoStatus.Information = 0;
	        	IoCompleteRequest(Irp, IO_NO_INCREMENT); // LZ
        	}else{
    			IoReleaseCancelSpinLock(Irp->CancelIrql); // ̂LZς݁@ʏ͂Ȃ͂
        	}
        }
    }
	g_pendingCounter = 0;
    
    // r̈Jn
    ExAcquireFastMutex(&g_Mutex);
    
    HostdrvStopTimer();
    
    // SOPXg
    MiniSOP_ReleaseSOPList();
    
    // r̈I
    ExReleaseFastMutex(&g_Mutex);
    
    // hCu蓖Ă̏ꍇA
    if(g_hostdrvNTOptions & HOSTDRVNTOPTIONS_AUTOMOUNTDRIVE){
    	if(g_autoMountDriveLetter != 0){
			UNICODE_STRING dosDriveNameUnicodeString;
	    	WCHAR dosDriveName[] = DOS_DRIVE_NAME;
			RtlInitUnicodeString(&dosDriveNameUnicodeString, dosDriveName);
			dosDriveNameUnicodeString.Buffer[12] = g_autoMountDriveLetter;
    		IoDeleteSymbolicLink(&dosDriveNameUnicodeString);
		}
    }
    
    // DOSo^
    RtlInitUnicodeString(&dosDeviceNameUnicodeString, DOS_DEVICE_NAME);
    IoDeleteSymbolicLink(&dosDeviceNameUnicodeString);
    
    // foCX폜
    IoDeleteDevice(DriverObject->DeviceObject);
    
    KdPrint(("Hostdrv: Unloaded\n"));
}

VOID HostdrvCancelRoutine(PDEVICE_OBJECT DeviceObject, PIRP Irp) {
    int i;
    
    // ҋ@LZvo^
    //IoSetCancelRoutine(Irp, NULL); // OSœȂ{͂炪
    Irp->CancelRoutine = NULL;
    
    // LZ̃bN
    IoReleaseCancelSpinLock(Irp->CancelIrql);
    
    // r̈Jn
    ExAcquireFastMutex(&g_Mutex);
    
	// w肳ꂽIRPo^
    for (i = 0; i < PENDING_IRP_MAX; i++) {
    	if(g_pendingIrpList[i] == Irp){
    		g_pendingIrpList[i] = NULL;
    		g_pendingAliveList[i] = 0;
			if(g_pendingCounter > 0) g_pendingCounter--;
		    break;
    	}
    }
    
	if(g_pendingCounter == 0){
		// ҋ@ȂΓKvȂ
		HostdrvStopTimer();
	}
    
    // r̈I
    ExReleaseFastMutex(&g_Mutex);
    
    // LZs
    Irp->IoStatus.Status = STATUS_CANCELLED;
    Irp->IoStatus.Information = 0;
    IoCompleteRequest(Irp, IO_NO_INCREMENT);
    
}

NTSTATUS HostdrvDispatch(IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp) {
    HOSTDRV_INFO hostdrvInfo;
    HOSTDRV_INFO *lpHostdrvInfo;
    ULONG hostdrvInfoAddr;
    PIO_STACK_LOCATION irpSp = IoGetCurrentIrpStackLocation(Irp);
#ifdef USE_FAST_IRPSTACKLOCK
	IRPSTACKLOCK_INFO irpLockInfo;
#else
    PIO_STACK_LOCATION irpSpNPP = NULL;
    PIO_STACK_LOCATION irpSpNPPBefore = NULL;
#endif
    BOOLEAN pending = FALSE;
	ULONG completeIrpCount = 0; // I/Oҋ@ō񊮗̂̐
	PIRP *completeIrpList = NULL; // I/Oҋ@ō񊮗IRP̃Xg
	ULONG sopIndex = -1;
	NTSTATUS status;
	int i;

    // IRP_MJ_CREATE̎AKvȃ蓖
    if(irpSp->MajorFunction == IRP_MJ_CREATE) {
        // FileObjectNULLȂُ͈̂Ȃ̂Œe
        if(irpSp->FileObject == NULL){
            Irp->IoStatus.Status = status = STATUS_INVALID_PARAMETER;
            Irp->IoStatus.Information = 0;
            IoCompleteRequest(Irp, IO_NO_INCREMENT);
            return status;
        }
        // FsContextSectionObjectPointerExAllocatePoolWithTag(NonPagedPool,`Ń蓖
        // NULL̂܂܂Ⴄ@Ŋ蓖ĂƐɓȂ̂Œ
        irpSp->FileObject->FsContext = ExAllocatePoolWithTag(NonPagedPool, sizeof(HOSTDRV_FSCONTEXT), "HSFC");
        if(irpSp->FileObject->FsContext == NULL){
		    Irp->IoStatus.Status = status = STATUS_INSUFFICIENT_RESOURCES;
		    Irp->IoStatus.Information = 0;
            IoCompleteRequest(Irp, IO_NO_INCREMENT);
            return status;
        }
        RtlZeroMemory(irpSp->FileObject->FsContext, sizeof(HOSTDRV_FSCONTEXT));
        
    	// SOP擾
	    ExAcquireFastMutex(&g_Mutex);
    	sopIndex = MiniSOP_GetSOPIndex(irpSp->FileObject->FileName);
	    ExReleaseFastMutex(&g_Mutex);
	    
    	if(sopIndex == -1){
        	ExFreePool(irpSp->FileObject->FsContext);
		    Irp->IoStatus.Status = status = STATUS_INSUFFICIENT_RESOURCES;
		    Irp->IoStatus.Information = 0;
            IoCompleteRequest(Irp, IO_NO_INCREMENT);
            return status;
		}
		irpSp->FileObject->SectionObjectPointer = MiniSOP_GetSOP(sopIndex);
    }
    
    // ftHg̃Xe[^Xݒ
    Irp->IoStatus.Status = status = STATUS_NOT_IMPLEMENTED;
    Irp->IoStatus.Information = 0;
    
    // G~[^ɓnf[^ݒ
#ifdef USE_FAST_IRPSTACKLOCK
	// y[WAEgȂ悤ɃbN
    irpLockInfo = LockIrpStack(irpSp);
    if(!irpLockInfo.isValid){
        Irp->IoStatus.Status = status = STATUS_INSUFFICIENT_RESOURCES;
        Irp->IoStatus.Information = 0;
        IoCompleteRequest(Irp, IO_NO_INCREMENT);
        return status;
    }
#else
	// y[WAEgȂ̈փRs[
    irpSpNPP = CreateNonPagedPoolIrpStack(irpSp); // NonPagedRs[쐬
    if(irpSpNPP == NULL){
        Irp->IoStatus.Status = status = STATUS_INSUFFICIENT_RESOURCES;
        Irp->IoStatus.Information = 0;
        IoCompleteRequest(Irp, IO_NO_INCREMENT);
        return status;
	}
	irpSpNPPBefore = irpSp;
	irpSp = irpSpNPP; // |C^
#endif
    lpHostdrvInfo = &hostdrvInfo;
    lpHostdrvInfo->stack = irpSp;
    lpHostdrvInfo->status = &(Irp->IoStatus);
    lpHostdrvInfo->systemBuffer = Irp->AssociatedIrp.SystemBuffer;
    lpHostdrvInfo->deviceFlags = irpSp->DeviceObject->Flags;
    if (Irp->MdlAddress != NULL) {
        // MdlAddressgړIȓ]
        lpHostdrvInfo->outBuffer = MmGetSystemAddressForMdl(Irp->MdlAddress); // ÂOSΉp
        //lpHostdrvInfo->outBuffer = MmGetSystemAddressForMdlSafe(Irp->MdlAddress, NormalPagePriority); // ŋ߂OSȂ炱\iSHj
        if(lpHostdrvInfo->systemBuffer == NULL){
        	lpHostdrvInfo->systemBuffer = lpHostdrvInfo->outBuffer;
        }
    } else if (Irp->AssociatedIrp.SystemBuffer != NULL) {
        // VXeobt@oRł̊ԐړIȓ]
        lpHostdrvInfo->outBuffer = Irp->AssociatedIrp.SystemBuffer;
    } else {
        // [U[wobt@ւ̓]
        lpHostdrvInfo->outBuffer = Irp->UserBuffer;
    }
    if (irpSp->FileObject) {
        lpHostdrvInfo->sectionObjectPointer = irpSp->FileObject->SectionObjectPointer;
    } else {
        lpHostdrvInfo->sectionObjectPointer = NULL;
    }
    lpHostdrvInfo->version = HOSTDRVNT_VERSION;
    lpHostdrvInfo->pendingListCount = PENDING_IRP_MAX;
    lpHostdrvInfo->pendingIrpList = g_pendingIrpList;
    lpHostdrvInfo->pendingAliveList = g_pendingAliveList;
    lpHostdrvInfo->pending.pendingIndex = -1;
    lpHostdrvInfo->hostdrvNTOptions = g_hostdrvNTOptions;
    
    if(irpSp->MajorFunction == IRP_MJ_SET_INFORMATION) {
	    MiniSOP_HandlePreMjSetInformationCache(irpSp);
 	}
 	
    // r̈Jn
    ExAcquireFastMutex(&g_Mutex);
    
    // \̃AhXŃG~[^ŏinCp[oCU[R[j
    // G~[^ŃXe[^Xobt@Ȃǂ̒lZbg
    hostdrvInfoAddr = (ULONG)lpHostdrvInfo;
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr));
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr >> 8));
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr >> 16));
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr >> 24));
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'H');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'D');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'R');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'9');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'8');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'0');
    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'1');
    if(Irp->IoStatus.Status == STATUS_PENDING){
    	// ҋ@]
    	if(lpHostdrvInfo->pending.pendingIndex < 0 || PENDING_IRP_MAX <= lpHostdrvInfo->pending.pendingIndex){
    		// o^łꏊȂ
		    Irp->IoStatus.Status = STATUS_INSUFFICIENT_RESOURCES;
		    Irp->IoStatus.Information = 0;
    	}else{
    		// o^OK@łg_pendingIrpListɑȂiƑXbhɊĂ܂ꂪj
    		pending = TRUE;
    	}
    }else if(lpHostdrvInfo->pending.pendingCompleteCount > 0){
    	// ҋ@݂
    	completeIrpCount = lpHostdrvInfo->pending.pendingCompleteCount;
        completeIrpList = ExAllocatePoolWithTag(NonPagedPool, sizeof(PIRP) * completeIrpCount, "HSIP");
        if(completeIrpList){
        	int ci = 0;
		    for (i = 0; i < PENDING_IRP_MAX; i++) {
		        if (g_pendingAliveList[i] == 0 && g_pendingIrpList[i] != NULL) {
		        	completeIrpList[ci] = g_pendingIrpList[i];
				    g_pendingIrpList[i] = NULL;
				    if(g_pendingCounter > 0) g_pendingCounter--;
				    ci++;
				    if (ci==completeIrpCount) break;
		        }
		    }
        }
		if(g_pendingCounter == 0){
			// ҋ@ȂΓKvȂ
			HostdrvStopTimer();
		}
    }
    
    // r̈I
    ExReleaseFastMutex(&g_Mutex);
    
    
#ifdef USE_FAST_IRPSTACKLOCK
	// bN
    UnlockIrpStack(&irpLockInfo);
#else
    // NonPagedRs[߂
    ReleaseNonPagedPoolIrpStack(irpSpNPP, irpSpNPPBefore);
	irpSp = irpSpNPPBefore; // |C^߂
    irpSpNPP = NULL;
#endif
    
    // t@CI[vEN[YȂǂŊ蓖Ă̏
    if(Irp->IoStatus.Status == STATUS_SUCCESS){
        // t@C̂Ŕj
        if(irpSp->MajorFunction == IRP_MJ_CLOSE) {
            if(irpSp->FileObject->SectionObjectPointer){
            	PSECTION_OBJECT_POINTERS sop;
            		
			    // SOP
			    ExAcquireFastMutex(&g_Mutex);
    			sop = irpSp->FileObject->SectionObjectPointer;
                irpSp->FileObject->SectionObjectPointer = NULL;
                MiniSOP_ReleaseSOP(sop);
			    ExReleaseFastMutex(&g_Mutex);
            }
            if(irpSp->FileObject->FsContext){
                ExFreePool(irpSp->FileObject->FsContext);
                irpSp->FileObject->FsContext = NULL;
            }
        }else if(irpSp->MajorFunction == IRP_MJ_CREATE) {
			MiniSOP_HandleMjCreateCache(irpSp);
        }else if(irpSp->MajorFunction == IRP_MJ_CLEANUP) {
		    MiniSOP_HandleMjCleanupCache(irpSp);
        }
    }else{
        // 肭sȂj
        if(irpSp->MajorFunction == IRP_MJ_CREATE) {
            if(sopIndex != -1){
			    // SOP
			    ExAcquireFastMutex(&g_Mutex);
                irpSp->FileObject->SectionObjectPointer = NULL;
                MiniSOP_ReleaseSOPByIndex(sopIndex);
			    ExReleaseFastMutex(&g_Mutex);
            }
            if(irpSp->FileObject->FsContext){
                ExFreePool(irpSp->FileObject->FsContext);
                irpSp->FileObject->FsContext = NULL;
            }
        }
    }
    
    // ҋ@݂ꍇA
    if(completeIrpList){
	    for (i = 0; i < completeIrpCount; i++) {
    		KIRQL oldIrql;
        	PIRP Irp = completeIrpList[i];
        	IoAcquireCancelSpinLock(&oldIrql);
        	if(Irp->CancelRoutine){
    			Irp->CancelRoutine = NULL;
    			IoReleaseCancelSpinLock(Irp->CancelIrql);
	        	IoCompleteRequest(Irp, IO_NO_INCREMENT); // SLŃZbgĂ̂ŊĂԂł悢
        	}else{
    			IoReleaseCancelSpinLock(Irp->CancelIrql); // ̂LZς݁@ʏ͂Ȃ͂
        	}
	    }
    	ExFreePool(completeIrpList);
    	completeIrpList = NULL;
    }
    
    if(pending){
    	KIRQL oldIrql;
    	
    	// ҋ@ɃZbg
        IoMarkIrpPending(Irp);
        
        IoAcquireCancelSpinLock(&oldIrql);  // یJn
        
	    // ɃLZς݂Ȃ炷ɏ
		if (Irp->Cancel) {
    		IoReleaseCancelSpinLock(oldIrql);  // ی
	        
		    // r̈Jn
		    ExAcquireFastMutex(&g_Mutex);
    
    		// XgɓKvȂB
    		g_pendingIrpList[lpHostdrvInfo->pending.pendingIndex] = NULL;
    		g_pendingAliveList[lpHostdrvInfo->pending.pendingIndex] = 0;

		    // r̈I
		    ExReleaseFastMutex(&g_Mutex);
    
	        Irp->IoStatus.Status = status = STATUS_CANCELLED;
	        Irp->IoStatus.Information = 0;
	        IoCompleteRequest(Irp, IO_NO_INCREMENT);
	    }else{
		    // ҋ@LZvo^
		    //IoSetCancelRoutine(Irp, HostdrvCancelRoutine); // OSœȂ{͂炪
    		Irp->CancelRoutine = HostdrvCancelRoutine;
		    
    		IoReleaseCancelSpinLock(oldIrql);  // ی
    		
		    // r̈Jn
		    ExAcquireFastMutex(&g_Mutex);
		    
    		// ۂɓo^
    		g_pendingIrpList[lpHostdrvInfo->pending.pendingIndex] = Irp;
			g_pendingCounter++;
			// KvȂĎ^C}[𓮂
		    if(g_hostdrvNTOptions & HOSTDRVNTOPTIONS_USECHECKNOTIFY){
		    	HostdrvStartTimer();
			}
    
		    // r̈I
		    ExReleaseFastMutex(&g_Mutex);
		    
    		status = Irp->IoStatus.Status;
	    }
    }else{
    	status = Irp->IoStatus.Status;
        IoCompleteRequest(Irp, IO_NO_INCREMENT);
    }
    return status;
}

VOID HostdrvTimerDpcRoutine(IN PKDPC Dpc, IN PVOID DeferredContext, IN PVOID SystemArgument1, IN PVOID SystemArgument2)
{
    if (!g_checkNotifyTimerEnabled) {
        return;
    }
    
	if(g_pendingCounter > 0 && g_checkNotifyTimerEnabled) {
    	// WorkItem֓ IRQL𗎂Ƃ
    	ExQueueWorkItem(&g_RescheduleTimerWorkItem, DelayedWorkQueue);
	}else{
		// ~
		g_checkNotifyTimerEnabled = 0;
	}
}
VOID HostdrvRescheduleTimer(IN PVOID Context)
{
	PHOSTDRV_NOTIFYINFO lpHostdrvInfo;
	ULONG hostdrvInfoAddr;
	ULONG completeIrpCount = 0; // I/Oҋ@ō񊮗̂̐
	PIRP *completeIrpList = NULL; // I/Oҋ@ō񊮗IRP̃Xg
	int i;
   
    lpHostdrvInfo = ExAllocatePoolWithTag(NonPagedPool, sizeof(HOSTDRV_NOTIFYINFO), "HSIM");
    
	// r̈Jn
    ExAcquireFastMutex(&g_Mutex);
    
    if(lpHostdrvInfo){
    	// G~[^ɓnf[^ݒ
	    lpHostdrvInfo->version = HOSTDRVNT_VERSION;
	    lpHostdrvInfo->pendingListCount = PENDING_IRP_MAX;
	    lpHostdrvInfo->pendingIrpList = g_pendingIrpList;
	    lpHostdrvInfo->pendingAliveList = g_pendingAliveList;
	    lpHostdrvInfo->pending.pendingCompleteCount = -1;
	    
	    // \̃AhXŃG~[^ŏinCp[oCU[R[j
	    // G~[^ŃXe[^Xobt@Ȃǂ̒lZbg
	    hostdrvInfoAddr = (ULONG)lpHostdrvInfo;
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr));
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr >> 8));
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr >> 16));
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_ADDR, (UCHAR)(hostdrvInfoAddr >> 24));
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'H');
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'D');
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'R');
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'9');
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'8');
	    WRITE_PORT_UCHAR((PUCHAR)HOSTDRVNT_IO_CMD, (UCHAR)'M');
	    if(lpHostdrvInfo->pending.pendingCompleteCount > 0){
	    	// ҋ@݂
	    	completeIrpCount = lpHostdrvInfo->pending.pendingCompleteCount;
	        completeIrpList = ExAllocatePoolWithTag(NonPagedPool, sizeof(PIRP) * completeIrpCount, "HSIP");
	        if(completeIrpList){
	        	int ci = 0;
			    for (i = 0; i < PENDING_IRP_MAX; i++) {
			        if (g_pendingAliveList[i] == 0 && g_pendingIrpList[i] != NULL) {
			        	completeIrpList[ci] = g_pendingIrpList[i];
					    g_pendingIrpList[i] = NULL;
					    if(g_pendingCounter > 0) g_pendingCounter--;
					    ci++;
					    if (ci==completeIrpCount) break;
			        }
			    }
	        }
	    }
    }

    // ^C}[Đݒ
	if(g_pendingCounter > 0 && g_checkNotifyTimerEnabled) {
    	// Đݒ
		LARGE_INTEGER dueTime = {0};
		dueTime.QuadPart = (LONGLONG)(-(LONG)g_checkNotifyInterval * 1000 * 10000);
		KeSetTimer(&g_checkNotifyTimer, dueTime, &g_checkNotifyTimerDpc);
	}else{
		// ~
		g_checkNotifyTimerEnabled = 0;
	}
    
    // r̈I
    ExReleaseFastMutex(&g_Mutex);
    
    if(lpHostdrvInfo){
    	ExFreePool(lpHostdrvInfo);
    }
    
    // ҋ@݂ꍇA
    if(completeIrpList){
	    for (i = 0; i < completeIrpCount; i++) {
    		KIRQL oldIrql;
        	PIRP Irp = completeIrpList[i];
        	IoAcquireCancelSpinLock(&oldIrql);
        	if(Irp->CancelRoutine){
    			Irp->CancelRoutine = NULL;
    			IoReleaseCancelSpinLock(Irp->CancelIrql);
	        	IoCompleteRequest(Irp, IO_NO_INCREMENT); // SLŃZbgĂ̂ŊĂԂł悢
        	}else{
    			IoReleaseCancelSpinLock(Irp->CancelIrql); // ̂LZς݁@ʏ͂Ȃ͂
        	}
	    }
    	ExFreePool(completeIrpList);
    	completeIrpList = NULL;
    }
}
