/**
 * @file	cmserial.h
 * @brief	VA NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "cmbase.h"

#define SERIAL_OVERLAP_COUNT	4
#define SERIAL_BLOCKBUFFER_SIZE_MAX	128

/**
 * xe[u
 */
const UINT32 cmserial_speed[] = {110, 300, 600, 1200, 2400, 4800,
							9600, 14400, 19200, 28800, 38400, 57600, 115200};

/**
 * @brief commng VA foCX NX
 */
class CComSerial : public CComBase
{
public:
	static CComSerial* CreateInstance(UINT nPort, UINT8 cParam, UINT32 nSpeed, UINT8 fixedspeed, UINT8 DSRcheck);

protected:
	CComSerial();
	virtual ~CComSerial();
	virtual UINT Read(UINT8* pData);
	virtual UINT Write(UINT8 cData);
	virtual UINT WriteRetry();
	virtual UINT LastWriteSuccess(); // Ō݂̏Ă邩`FbN
	virtual UINT8 GetStat();
	virtual INTPTR Message(UINT nMessage, INTPTR nParam);
	virtual void BeginBlockTransfer();
	virtual void EndBlockTransfer();

private:
	HANDLE m_hSerial;		/*!< VA nh */
	
	OVERLAPPED m_writeovl[SERIAL_OVERLAP_COUNT];	/*!< OVERLAPPED */
	OVERLAPPED m_readovl;	/*!< ǂݍOVERLAPPED */
	bool m_writeovl_pending[SERIAL_OVERLAP_COUNT];	/*!< OVERLAPPEDҋ@ */
	bool m_readovl_pending;	/*!< ǂݍOVERLAPPEDҋ@ */
	UINT8 m_readovl_buf;	/*!< ǂݍOVERLAPPEDobt@ */
	
	bool m_blocktransfer;			/*!< ubNPʏ݃[h */
	UINT8 m_blockbuffer[SERIAL_BLOCKBUFFER_SIZE_MAX];		/*!< ubNobt@ */
	int m_blockbuffer_pos;		/*!< ubNobt@݈ʒu */
	int m_blockbuffer_size;		/*!< ubNobt@TCY */

	bool m_fixedspeed;	/*!< ʐMxŒ */
	UINT8 m_lastdata; // Ōɑ낤Ƃf[^
	UINT8 m_lastdatafail; // f[^𑗂̂ɎsĂ0ȊO
	DWORD m_lastdatatime; // f[^𑗂̂Ɏsԁi܂ɂs悤Ȃ疳j

	UINT8 m_errorstat; // G[ (bit0: peB, bit1: I[o[, bit2: t[~O)

	bool Initialize(UINT nPort, UINT8 cParam, UINT32 nSpeed, UINT8 fixedspeed, UINT8 DSRcheck);
	void CheckCommError(DWORD errorcode);
};
