/**
 * @file	externalopm.h
 * @brief	O OPM tNX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "externalchip.h"

/**
 * @brief O OPM tNX
 */
class CExternalOpm : public IExternalChip
{
public:
	CExternalOpm(IExternalChip* pChip);
	virtual ~CExternalOpm();
	virtual ChipType GetChipType();
	virtual void Reset();
	virtual void WriteRegister(UINT nAddr, UINT8 cData);
	virtual INTPTR Message(UINT nMessage, INTPTR nParameter);

protected:
	IExternalChip* m_pChip;				/*!< `bv */
	UINT8 m_cAlgorithm[8];				/*!< ASY e[u */
	UINT8 m_cTtl[8 * 4];				/*!< TTL e[u */

	void Mute(bool bMute) const;
	void WriteRegisterInner(UINT nAddr, UINT8 cData) const;
	void SetVolume(UINT nChannel, int nVolume) const;
};
