/**
 * @file	DlgProc.cpp
 * @brief	_CAO NX̓̒`s܂
 */

#include "compiler.h"
#include "DlgProc.h"

BOOL winloc_GetWindowRect(HWND hwnd, LPRECT lpRect);

/**
 * RXgN^
 */
CDlgProc::CDlgProc()
	: m_lpszTemplateName(NULL)
	, m_hwndParent(NULL)
{
}

/**
 * RXgN^
 * @param[in] nIDTemplate _CAO {bNX ev[g̃\[X id ԍw肵܂
 * @param[in] hwndParent eEBhE
 */
CDlgProc::CDlgProc(UINT nIDTemplate, HWND hwndParent)
	: m_lpszTemplateName(MAKEINTRESOURCE(nIDTemplate))
	, m_hwndParent(hwndParent)
{
}

/**
 * fXgN^
 */
CDlgProc::~CDlgProc()
{
}

/**
 * [_
 * @return _CAO {bNX邽߂ɎgpACDialog::EndDialog ̃o[֐ɓnꂽ nResult ̃p[^[lw肷 int ̒l
 */
INT_PTR CDlgProc::DoModal()
{
	HookWindowCreate(this);

	HINSTANCE hInstance = FindResourceHandle(m_lpszTemplateName, RT_DIALOG);
	const INT_PTR nRet = ::DialogBox(hInstance, m_lpszTemplateName, m_hwndParent, DlgProc);

	if (!UnhookWindowCreate())
	{
		PostNcDestroy();
	}
	return nRet;
}

/**
 * _CAO vV[W
 * @param[in] hWnd EBhE nh
 * @param[in] message  Windows bZ[Ww肵܂
 * @param[in] wParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @param[in] lParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @return bZ[WɈˑlԂ܂
 */
#if defined(_WIN64)
INT_PTR CALLBACK CDlgProc::DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
#else	// defined(_WIN64)
BOOL CALLBACK CDlgProc::DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
#endif	// defined(_WIN64)
{
	if (message == WM_INITDIALOG)
	{
		CDlgProc* pDlg = static_cast<CDlgProc*>(FromHandlePermanent(hWnd));
		if (pDlg != NULL)
		{
			return pDlg->OnInitDialog();
		}
		else
		{
			return TRUE;
		}
	}
	return FALSE;
}

/**
 * CDlgProc IuWFNg Windows vV[W
 * @param[in] nMsg  Windows bZ[Ww肵܂
 * @param[in] wParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @param[in] lParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @return bZ[WɈˑlԂ܂
 */
LRESULT CDlgProc::WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	if (nMsg == WM_COMMAND)
	{
		switch (LOWORD(wParam))
		{
			case IDOK:
				OnOK();
				return TRUE;

			case IDCANCEL:
				OnCancel();
				return TRUE;
		}
	}else if(nMsg == WM_INITDIALOG){
		RECT rect, rect2, rectparent;
		GetWindowRect(&rect);
		if(!winloc_GetWindowRect(m_hWnd,&rect2)){
			rect2 = rect;
		}

		CWndBase wndParent = GetParent();
		wndParent.GetWindowRect(&rectparent);

		POINT pt;
		pt.x = rectparent.left - (rect2.left - rect.left);//((rectparent.right - rectparent.left) - (rect.right - rect.left)) / 2;
		pt.y = rectparent.top - (rect2.top - rect.top);//((rectparent.bottom - rectparent.top) - (rect.bottom - rect.top)) / 2;
		MoveWindow(pt.x, pt.y, (rect.right - rect.left), (rect.bottom - rect.top), TRUE);
	}
	return CWndProc::WindowProc(nMsg, wParam, lParam);
}

/**
 * ̃\bh WM_INITDIALOG ̃bZ[WɉČĂяo܂
 * @retval TRUE ŏ̃Rg[ɓ̓tH[JXݒ
 * @retval FALSE ɐݒ
 */
BOOL CDlgProc::OnInitDialog()
{
	return TRUE;
}

/**
 * [U[ OK ̃{^ (IDOK ID ̃{^) NbNƌĂяo܂
 */
void CDlgProc::OnOK()
{
	EndDialog(IDOK);
}

/**
 * t[[ŃA[U[ [LZ] NbN邩A[_܂̓[hX _CAO {bNX Esc L[Ƃɂ̃\bhĂяo܂
 */
void CDlgProc::OnCancel()
{
	EndDialog(IDCANCEL);
}



/**
 * RXgN^
 * @param[in] bOpenFileDialog 쐬_CAO {bNXw肷p[^[
 * @param[in] lpszDefExt ̃t@C̊gqł
 * @param[in] lpszFileName {bNXɕ\鏉t@C
 * @param[in] dwFlags tO
 * @param[in] lpszFilter tB^[
 * @param[in] hParentWnd eEBhE
 */
CFileDlg::CFileDlg(BOOL bOpenFileDialog, LPCTSTR lpszDefExt, LPCTSTR lpszFileName, DWORD dwFlags, LPCTSTR lpszFilter, HWND hParentWnd)
	: m_bOpenFileDialog(bOpenFileDialog)
{
	ZeroMemory(&m_ofn, sizeof(m_ofn));
	m_szFileName[0] = '\0';
	m_szFileTitle[0] = '\0';

	m_ofn.lStructSize = sizeof(m_ofn);
	m_ofn.lpstrFile = m_szFileName;
	m_ofn.nMaxFile = _countof(m_szFileName);
	m_ofn.lpstrDefExt = lpszDefExt;
	m_ofn.lpstrFileTitle = m_szFileTitle;
	m_ofn.nMaxFileTitle = _countof(m_szFileTitle);
	m_ofn.Flags = dwFlags;
	m_ofn.hwndOwner = hParentWnd;

	// setup initial file name
	if (lpszFileName != NULL)
	{
		lstrcpyn(m_szFileName, lpszFileName, _countof(m_szFileName));
	}

	// Translate filter into commdlg format (lots of \0)
	if (lpszFilter != NULL)
	{
		m_strFilter = lpszFilter;
		for (std::tstring::iterator it = m_strFilter.begin(); it != m_strFilter.end(); ++it)
		{
#if !defined(_UNICODE)
			if (IsDBCSLeadByte(static_cast<BYTE>(*it)))
			{
				++it;
				if (it == m_strFilter.end())
				{
					break;
				}
				continue;
			}
#endif	// !defined(_UNICODE)
			if (*it == '|')
			{
				*it = '\0';
			}
		}
		m_ofn.lpstrFilter = m_strFilter.c_str();
	}
}

/**
 * [_
 * @return Ug R[h
 */
int CFileDlg::DoModal()
{
	int nResult;
	if (m_bOpenFileDialog)
	{
		nResult = ::GetOpenFileName(&m_ofn);
	}
	else
	{
		nResult = ::GetSaveFileName(&m_ofn);
	}
	return nResult;
}
