/**
 *	@file	np2arg.h
 *	@brief	NX̐錾уC^[tFCX̒`܂
 */

#pragma once

/**
 * @brief NX
 */
class Np2Arg
{
public:
	static Np2Arg* GetInstance();
	static void Release();

	Np2Arg();
	~Np2Arg();
	void Parse();
	void ClearDisk();
	LPCTSTR disk(int nDrive) const;
	LPCTSTR cdisk(int nDrive) const;
	LPCTSTR iniFilename() const;
	bool fullscreen() const;
	void setiniFilename(LPTSTR newfile);

private:
	static Np2Arg sm_instance;		//!< B̃CX^Xł

	LPCTSTR m_lpDisk[4];	//!< fBXN
	LPCTSTR m_lpCDisk[4];	//!< CD
	LPTSTR m_lpIniFile;	//!< ݒt@C
	bool m_fFullscreen;		//!< tXN[ [h
	LPTSTR m_lpArg;			//!< [N
};

/**
 * CX^X𓾂
 * @return CX^X
 */
inline Np2Arg* Np2Arg::GetInstance()
{
	return &sm_instance;
}

/**
 * 
 */
inline void Np2Arg::Release()
{
	if(sm_instance.m_lpArg){
		free(sm_instance.m_lpArg);
		sm_instance.m_lpArg = NULL;
	}
	if(sm_instance.m_lpIniFile){
		free(sm_instance.m_lpIniFile); // np21w ver0.86 rev8
		sm_instance.m_lpIniFile = NULL;
	}
}

/**
 * fBXN pX𓾂
 * @param[in] nDrive hCu
 * @return fBXN pX
 */
inline LPCTSTR Np2Arg::disk(int nDrive) const
{
	return m_lpDisk[nDrive];
}

/**
 * CD pX𓾂
 * @param[in] nDrive hCu
 * @return fBXN pX
 */
inline LPCTSTR Np2Arg::cdisk(int nDrive) const
{
	return m_lpCDisk[nDrive];
}

/**
 * INI pX𓾂
 * @return INI pX
 */
inline LPCTSTR Np2Arg::iniFilename() const
{
	return m_lpIniFile;
}

/**
 * tXN[𓾂
 * @retval true tXN[ [h
 * @retval false EBhE [h
 */
inline bool Np2Arg::fullscreen() const
{
	return m_fFullscreen;
}

/**
 * INI pX𓾂
 * @return INI pX
 */
inline void Np2Arg::setiniFilename(LPTSTR newfile)
{
	if(m_lpIniFile){
		free(m_lpIniFile);
		m_lpIniFile = NULL;
	}
	m_lpIniFile = newfile;
}

