/**
 * @file	soundmng.cpp
 * @brief	TEh }l[W NX̓̒`s܂
 */

#include "compiler.h"
#include "soundmng.h"
#include "np2.h"
#if defined(SUPPORT_ROMEO)
#include "ext\externalchipmanager.h"
#endif
#if defined(MT32SOUND_DLL)
#include "ext\mt32snd.h"
#endif
#if defined(SUPPORT_ASIO)
#include "soundmng\sdasio.h"
#endif	// defined(SUPPORT_ASIO)
#include "soundmng\sddsound3.h"
#if defined(SUPPORT_WASAPI)
#include "soundmng\sdwasapi.h"
#endif	// defined(SUPPORT_WASAPI)
#include "common\parts.h"
#include "sound\sound.h"
#if defined(VERMOUTH_LIB)
#include "sound\vermouth\vermouth.h"
#endif
#include	"np2mt.h"

#if !defined(_WIN64)
#ifdef __cplusplus
extern "C"
{
#endif
/**
 * satuation
 * @param[out] dst o̓obt@
 * @param[in] src ̓obt@
 * @param[in] size TCY
 */
void __fastcall satuation_s16mmx(SINT16 *dst, const SINT32 *src, UINT size);
#ifdef __cplusplus
}
#endif
#endif

#if defined(VERMOUTH_LIB)
	MIDIMOD		vermouth_module = NULL;
#endif

//! B̃CX^Xł
CSoundMng CSoundMng::sm_instance;

/**
 * 
 */
void CSoundMng::Initialize()
{
#if defined(SUPPORT_ASIO) || defined(SUPPORT_WASAPI)
	::CoInitializeEx(NULL, COINIT_MULTITHREADED);
#endif	// defined(SUPPORT_ASIO) || defined(SUPPORT_WASAPI)

	CSoundDeviceDSound3::s_mastervol_available = true;//np2oscfg.usemastervolume ? true : false;
	CSoundDeviceDSound3::Initialize();
#if defined(SUPPORT_WASAPI)
	CSoundDeviceWasapi::Initialize();
#endif	// defined(SUPPORT_WASAPI)

#if defined(SUPPORT_ASIO)
	CSoundDeviceAsio::Initialize();
#endif	// defined(SUPPORT_ASIO)

#if defined(SUPPORT_ROMEO)
	CExternalChipManager::GetInstance()->Initialize();
#endif	// defined(SUPPORT_ROMEO)

	CSoundMng::GetInstance()->InitializeSoundCriticalSection();
}

/**
 * 
 */
void CSoundMng::Deinitialize()
{
#if defined(SUPPORT_ROMEO)
	CExternalChipManager::GetInstance()->Deinitialize();
#endif	// defined(SUPPORT_ROMEO)

#if defined(SUPPORT_WASAPI)
	CSoundDeviceWasapi::Deinitialize();
#endif	// defined(SUPPORT_WASAPI)

#if defined(SUPPORT_ASIO) || defined(SUPPORT_WASAPI)
	::CoUninitialize();
#endif	// defined(SUPPORT_ASIO) || defined(SUPPORT_WASAPI)
	
	CSoundMng::GetInstance()->FinalizeSoundCriticalSection();
}

/**
 * RXgN^
 */
CSoundMng::CSoundMng()
	: m_pSoundDevice(NULL)
	, m_nMute(0)
	, m_sound_cs_initialized(false)
{
	SetReverse(false);
}

/**
 * I[v
 * @param[in] nType foCX ^Cv
 * @param[in] lpName foCX
 * @param[in] hWnd EBhE nh
 * @retval true 
 * @retval false s
 */
bool CSoundMng::Open(DeviceType nType, LPCTSTR lpName, HWND hWnd)
{
	EnterAllCriticalSection();

	Close();

	CSoundDeviceBase* pSoundDevice = NULL;
	switch (nType)
	{
		case kDefault:
			pSoundDevice = new CSoundDeviceDSound3;
			lpName = NULL;
			break;

		case kDSound3:
			pSoundDevice = new CSoundDeviceDSound3;
			break;

#if defined(SUPPORT_WASAPI)
		case kWasapi:
			pSoundDevice = new CSoundDeviceWasapi;
			break;
#endif	// defined(SUPPORT_WASAPI)

#if defined(SUPPORT_ASIO)
		case kAsio:
			pSoundDevice = new CSoundDeviceAsio;
			break;
#endif	// defined(SUPPORT_ASIO)
	}

	if (pSoundDevice)
	{
		if (!pSoundDevice->Open(lpName, hWnd))
		{
			delete pSoundDevice;
			pSoundDevice = NULL;
		}
	}

	if (pSoundDevice == NULL)
	{
		LeaveSoundCriticalSection();
		return false;
	}

	m_pSoundDevice = pSoundDevice;

#if defined(MT32SOUND_DLL)
	MT32Sound::GetInstance()->Initialize();
#endif
	
	LeaveAllCriticalSection();
	return true;
}

/**
 * N[Y
 */
void CSoundMng::Close()
{
	EnterAllCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->Close();
		delete m_pSoundDevice;
		m_pSoundDevice = NULL;
	}

#if defined(MT32SOUND_DLL)
	MT32Sound::GetInstance()->Deinitialize();
#endif
	LeaveAllCriticalSection();
}

/**
 * TEhL
 * @param[in] nProc vV[W
 */
void CSoundMng::Enable(SoundProc nProc)
{
	EnterSoundCriticalSection();
	const UINT nBit = 1 << nProc;
	if (!(m_nMute & nBit))
	{
		LeaveSoundCriticalSection();
		return;
	}
	m_nMute &= ~nBit;
	if (!m_nMute)
	{
		if (m_pSoundDevice)
		{
			m_pSoundDevice->PlayStream();
		}
#if defined(SUPPORT_ROMEO)
		CExternalChipManager::GetInstance()->Mute(false);
#endif	// defined(SUPPORT_ROMEO)
	}
	LeaveSoundCriticalSection();
}

/**
 * TEh
 * @param[in] nProc vV[W
 */
void CSoundMng::Disable(SoundProc nProc)
{
	EnterSoundCriticalSection();
	if (!m_nMute)
	{
		if (m_pSoundDevice)
		{
			m_pSoundDevice->StopStream();
			m_pSoundDevice->StopAllPCM();
		}
#if defined(SUPPORT_ROMEO)
		CExternalChipManager::GetInstance()->Mute(true);
#endif	// defined(SUPPORT_ROMEO)
	}
	m_nMute |= (1 << nProc);
	LeaveSoundCriticalSection();
}

/**
 * Xg[쐬
 * @param[in] nSamplingRate TvO [g
 * @param[in] ms obt@(~b)
 * @return obt@
 */
UINT CSoundMng::CreateStream(UINT nSamplingRate, UINT ms)
{
	EnterAllCriticalSection();
	if (m_pSoundDevice == NULL)
	{
		LeaveSoundCriticalSection();
		return 0;
	}

	if (ms < 40)
	{
		ms = 40;
	}
	else if (ms > 1000)
	{
		ms = 1000;
	}
	UINT nBuffer = (nSamplingRate * ms) / 2000;
	nBuffer = (nBuffer + 1) & (~1);

	nBuffer = m_pSoundDevice->CreateStream(nSamplingRate, 2, nBuffer);
	if (nBuffer == 0)
	{
		LeaveSoundCriticalSection();
		return 0;
	}
	m_pSoundDevice->SetStreamData(this);

#if defined(VERMOUTH_LIB)
	vermouth_module = midimod_create(nSamplingRate);
	midimod_loadall(vermouth_module);
#endif

#if defined(MT32SOUND_DLL)
	MT32Sound::GetInstance()->SetRate(nSamplingRate);
#endif

	LeaveAllCriticalSection();
	return nBuffer;
}

/**
 * Xg[j
 */
inline void CSoundMng::DestroyStream()
{
	if (m_pSoundDevice)
	{
		m_pSoundDevice->DestroyStream();
	}

#if defined(VERMOUTH_LIB)
	midimod_destroy(vermouth_module);
	vermouth_module = NULL;
#endif
#if defined(MT32SOUND_DLL)
	MT32Sound::GetInstance()->SetRate(0);
#endif
}

/**
 * Xg[̃Zbg
 */
inline void CSoundMng::ResetStream()
{
	EnterSoundCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->ResetStream();
	}
	LeaveSoundCriticalSection();
}

/**
 * Xg[̍Đ
 */
inline void CSoundMng::PlayStream()
{
	EnterSoundCriticalSection();
	if (!m_nMute)
	{
		if (m_pSoundDevice)
		{
			m_pSoundDevice->PlayStream();
		}
	}
	LeaveSoundCriticalSection();
}

/**
 * Xg[̒~
 */
inline void CSoundMng::StopStream()
{
	EnterSoundCriticalSection();
	if (!m_nMute)
	{
		if (m_pSoundDevice)
		{
			m_pSoundDevice->StopStream();
		}
	}
	LeaveSoundCriticalSection();
}

/**
 * Xg[𓾂
 * @param[out] lpBuffer obt@
 * @param[in] nBufferCount obt@ JEg
 * @return Tv
 */
UINT CSoundMng::Get16(SINT16* lpBuffer, UINT nBufferCount)
{
	EnterSoundCriticalSection();
	const SINT32* lpSource = ::sound_pcmlock();
	if (lpSource)
	{
		(*m_fnMix)(lpBuffer, lpSource, nBufferCount * 4);
		::sound_pcmunlock(lpSource);
		LeaveSoundCriticalSection();
		return nBufferCount;
	}
	else
	{
		LeaveSoundCriticalSection();
		return 0;
	}
}

/**
 * p]ݒ肷
 * @param[in] bReverse ]tO
 */
inline void CSoundMng::SetReverse(bool bReverse)
{
	EnterSoundCriticalSection();
	if (!bReverse)
	{
#if !defined(_WIN64)
		if (mmxflag)
		{
			m_fnMix = satuation_s16;
		}
		else {
			m_fnMix = satuation_s16mmx;
		}
#else
		m_fnMix = satuation_s16;
#endif
	}
	else
	{
		m_fnMix = satuation_s16x;
	}
	LeaveSoundCriticalSection();
}

/**
 * }X^[ H[ݒ
 * @param[in] nVolume H[
 */
void CSoundMng::SetMasterVolume(int nVolume)
{
	EnterSoundCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->SetMasterVolume(nVolume);
	}
	LeaveSoundCriticalSection();
}

/**
 * PCM f[^ǂݍ
 * @param[in] nNum PCM ԍ
 * @param[in] lpFilename t@C
 */
void CSoundMng::LoadPCM(SoundPCMNumber nNum, LPCTSTR lpFilename)
{
	EnterSoundCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->LoadPCM(nNum, lpFilename);
	}
	LeaveSoundCriticalSection();
}

/**
 * PCM f[^ēǂݍ
 * @param[in] nNum PCM ԍ
 * @param[in] lpFilename t@C
 */
void CSoundMng::ReloadPCM(SoundPCMNumber nNum)
{
	EnterSoundCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->ReloadPCM(nNum);
	}
	LeaveSoundCriticalSection();
}

/**
 * PCM H[ݒ
 * @param[in] nNum PCM ԍ
 * @param[in] nVolume H[
 */
void CSoundMng::SetPCMVolume(SoundPCMNumber nNum, int nVolume)
{
	EnterSoundCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->SetPCMVolume(nNum, nVolume);
	}
	LeaveSoundCriticalSection();
}

/**
 * PCM Đ
 * @param[in] nNum PCM ԍ
 * @param[in] bLoop [v tO
 * @retval true 
 * @retval false s
 */
inline bool CSoundMng::PlayPCM(SoundPCMNumber nNum, BOOL bLoop)
{
	EnterSoundCriticalSection();
	if (!m_nMute)
	{
		if (m_pSoundDevice)
		{
			LeaveSoundCriticalSection();
			return m_pSoundDevice->PlayPCM(nNum, bLoop);
		}
	}
	LeaveSoundCriticalSection();
	return false;
}

/**
 * PCM ~
 * @param[in] nNum PCM ԍ
 */
inline void CSoundMng::StopPCM(SoundPCMNumber nNum)
{
	EnterSoundCriticalSection();
	if (m_pSoundDevice)
	{
		m_pSoundDevice->StopPCM(nNum);
	}
	LeaveSoundCriticalSection();
}

// NeBJZNV֘A
void CSoundMng::InitializeSoundCriticalSection()
{
	if(!m_sound_cs_initialized){
		InitializeCriticalSection(&m_sound_cs);
		m_sound_cs_initialized = true;
	}
}
void CSoundMng::FinalizeSoundCriticalSection()
{
	if(m_sound_cs_initialized){
		DeleteCriticalSection(&m_sound_cs);
		m_sound_cs_initialized = false;
	}
}
void CSoundMng::EnterSoundCriticalSection()
{
	if(m_sound_cs_initialized){
		EnterCriticalSection(&m_sound_cs);
	}
}
void CSoundMng::LeaveSoundCriticalSection()
{
	if(m_sound_cs_initialized){
		LeaveCriticalSection(&m_sound_cs);
	}
}
void CSoundMng::EnterAllCriticalSection()
{
	np2_multithread_EnterCriticalSection();
	EnterSoundCriticalSection();
}
void CSoundMng::LeaveAllCriticalSection()
{
	LeaveSoundCriticalSection();
	np2_multithread_LeaveCriticalSection();
}

// ---- C bp[

/**
 * Xg[쐬
 * @param[in] rate TvO [g
 * @param[in] ms obt@(~b)
 * @return obt@ TCY
 */
UINT soundmng_create(UINT rate, UINT ms)
{
	UINT result;
	result = CSoundMng::GetInstance()->CreateStream(rate, ms);
	return result;
}

/**
 * Xg[j
 */
void soundmng_destroy(void)
{
	CSoundMng::GetInstance()->DestroyStream();
}

/**
 * Xg[ Zbg
 */
void soundmng_reset(void)
{
	CSoundMng::GetInstance()->ResetStream();
}

/**
 * Xg[Jn
 */
void soundmng_play(void)
{
	CSoundMng::GetInstance()->PlayStream();
}

/**
 * Xg[~
 */
void soundmng_stop(void)
{
	CSoundMng::GetInstance()->StopStream();
}

/**
 * Xg[ p]ݒ
 * @param[in] bReverse ]
 */
void soundmng_setreverse(BOOL bReverse)
{
	CSoundMng::GetInstance()->SetReverse((bReverse) ? true : false);
}

/**
 * {[ݒ
 * @param[in] nVolume {[(ŏ 0 ` 100 ő)
 */
void soundmng_setvolume(int nVolume)
{
	CSoundMng::GetInstance()->SetMasterVolume(nVolume);
}

/**
 * PCM Đ
 * @param[in] nNum PCM ԍ
 * @param[in] bLoop [v
 * @retval SUCCESS 
 * @retval FAILURE s
 */
BRESULT soundmng_pcmplay(enum SoundPCMNumber nNum, BOOL bLoop)
{
	BRESULT result;
	result = (CSoundMng::GetInstance()->PlayPCM(nNum, bLoop)) ? SUCCESS : FAILURE;
	return result;
}

/**
 * PCM ~
 * @param[in] nNum PCM ԍ
 */
void soundmng_pcmstop(enum SoundPCMNumber nNum)
{
	CSoundMng::GetInstance()->StopPCM(nNum);
}


