# Appendix 1: System Bus Interplay

The system bus is defined as the inter-chip address, data, and control signals. This system has several bus masters. Two of them (Suzy and the CPU) perform functions that do not require the system bus but do use an internal bus. It is defined that these activities on an internal bus will be reflected on the system bus whenever possible and without using the pertinent activation strobes (no RAS or CAS).

To allow simultaneous operation of bus masters on their internal busses and singular operation on the system bus would have resulted in interleaving the bus masters addresses. This eliminates the performance advantage of page mode. Any performance gained by simultaneous operation is related to the amount of non-system bus activity required and is still limited by the system bus bandwidth. Analysis of the activities of the two masters indicates that we will have higher performance with singular bus operation using page mode than simultaneous bus operation at reduced system bus efficiency.

There is, however, a situation in Suzy where the bus may be relinquished to Mikey while Suzy is processing an internal function. In this case, the internal function in Suzy will be allowed to continue while Mikey has the bus. At the completion of the internal function, Suzy will stop.

We will allow only one bus master at a time to be operational on the system bus.

The bus masters (in order of priority) are:

1. Video
2. Refresh
3. CPU
4. Suzy

Video and refresh requests should occur together whenever possible. This will reduce the overhead of acquiring the bus from Suzy.

There is no default owner of the bus. If no one wants it, it is un-used. When in this un-used condition, the system is 'asleep'.

**BIG NOTE:** Sleep is broken in Mikey. See the hardware spec.

There are two inter-chip bus handshake lines, bus request and bus grant. Bus request comes from Mikey and is the logical 'or' of the internal CPU, video, and refresh bus requests. Bus grant comes from Suzy and is generated by Suzy's bus controller.

## 1. Bus Controllers

There are two bus controllers, one in Mikey and the other in Suzy. The Mikey controller handles the CPU, video, refresh, and the bus grant from Suzy. The controller in Suzy handles the Suzy internals, the bus request from Mikey, and the bus grant to Mikey.

## 2. Suzy Bus Controller

### Internals/Externals

In order to maintain high bus efficiency in Suzy, it can not give up the bus on any arbitrary cycle. Suzy will have certain cycles in which it can give up the bus in response to a request from Mikey. Knowledge of those cycles is available to the bus handshake logic.

### Suzy External Bus Handshake

Suzy has a bus enable flip-flop that is controlled by the CPU. If the flip-flop is reset, Suzy will release the bus at her next appropriate cycle and will not try to re-acquire it. This flip-flop is reset by the CPU and by the system reset signal. When the flip-flop is set by the CPU, Suzy can now monitor the bus request line from Mikey and when it is off, Suzy can acquire the bus. As soon as Suzy begins acquiring the bus, she will set the bus grant line off. Suzy will only do this if in fact she wants the bus. After Suzy has the bus, she will relinquish it for only two reasons. The first is that Suzy is done with her task and no longer needs the bus. The second is that the bus request signal from Mikey has come on. In both cases, the bus grant to Mikey is set on when the appropriate cycle in Suzy occurs.

The off state of the Suzy bus enable flip-flop does not modify or reset the internal functioning of Suzy. It may be set or reset by the CPU at any time without adversely affecting the operation of the Suzy internals. This flip-flop only controls Suzys access to the bus. When Suzy is performing a function that requires the bus, it will merely pause until the bus becomes available.

## 3. Mikey Bus Controller

The Mikey bus controller has 3 requestors for its bus, the CPU, the video, and refresh. After system reset, the video and refresh are disabled and the CPU request is on. The CPU, when appropriate, can enable the video and refresh circuits to request the bus. See the state machine description (appendix 7) for cycle by cycle details of bus acquisition.

### 3.1 CPU Bus Release

When the CPU wishes to release the system bus (either to go to sleep or to allow Suzy to have the bus), it resets its bus request flip-flop. This flip-flop can only be reset by the CPU. It can be set by system reset, any unmasked interrupt, and Suzys bus grant coming on (oops! the return of bus grant from a request generated by a ref or vid will look like a suzy done edge. I don't know how to separately identify them!!!!)(Perhaps we can pulse the bus grant line from off to on to off to on. This is an unnatural signal and can be detected by the CPU flip flop.). Care must be taken in the hardware design to never miss the bus grant edge nor to falsely identify one. When the CPU resets its bus request flip-flop, and if no other Mikey master is requesting the bus, the bus request line will drop. If Suzy wants the bus, she can now take it. If not, then no one wants the bus and the system goes to sleep.

**BIG NOTE:** Sleep is broken in Mikey. See the hardware spec.

### 3.2 CPU Bus Request

Once the CPU has released the bus, it will only get it back when its bus request flip-flop is set as described above. When it gets set, one of the following situations is occurring:

- **System Reset.** That condition is described elsewhere.
- **Suzy Bus Grant.** Suzy is done, and the CPU can now continue processing. Suzy has already set bus grant, so when the CPU requests the bus, he will get it.
- **Interrupt.** If no one has the bus (the system was asleep), the CPU will get the bus as soon as it requests it. If Suzy has the bus, she is monitoring the bus request line and will grant the bus to Mikey when appropriate.

### 3.3 Video/Refresh Request

The video and refresh circuits will regularly request the bus unless they are disabled. When this request occurs, one of the following will happen:

**The CPU has the bus.** At the appropriate point in the state machine cycle, the bus controller will pause the CPU clock and give control to the video or refresh requestor.

**Suzy has the bus.** Mikey sends the bus request line to Suzy. At the appropriate point in Suzys cycle she sets the bus grant line. At that point the Mikey bus controller can give control to the video or refresh requestor.

**System was asleep.** No one has the bus and the bus controller will give it to the requestor.

## 4. Bus Request/Grant Summary

In summary, the functioning of each of the bus players can be isolated to its particular surroundings as follows:

1. Suzy has a bus enable flip-flop. If it is on, Suzy can participate in the bus game. If not, then Suzy ignores bus request and always provides bus grant.

2. If the bus enable flip-flop is on and if Suzy wants the bus, then she will monitor the bus request line. When that line is off, Suzy will then acquire the bus and reset the bus grant line. When the bus request line comes on, Suzy will (eventually) relinquish the bus and set the bus grant line on.

3. When Suzy is done with the bus, she will give it back by setting (or pulsing) the bus grant line.

4. When the video wants the bus, it will set its bus request line. Eventually, it will see that it has been made owner of the cycle and it will proceed. When it is done, it will reset its bus request line.

5. When the refresh wants the bus, it will set its bus request line. Eventually, it will see that it has been made owner of the cycle and it will proceed. When it is done, it will reset its bus request line.

6. When the CPU needs to get the bus, the decider of the need will set the CPU bus request line. Eventually, it will see that it has been made owner of the cycle and it will proceed. When it is done, it will reset its bus request line.

7. The logical 'or' of the CPU, the video, and the refresh 'bus request' signals is sent from Mikey to Suzy as the inter-chip bus request signal.
